-- SELECT --
use Filmler
-- Filmler veritabann kullan
--: yorum satr, *: tm stunlar, select: nelerin dnecei, from: hangi tablodan
select * from Film
select id, adi, yapimyili, yonetmen_id, gisesi from Film
-- SQL sorgularnda sadece ihtiyacmz olan stunlar getirmekte fayda var.
-- Bir tablo kendi kendine de iliki kurabilir.
select id as [Film ID], adi as [Film Adi], yapimyili as [Yapim Yili], yonetmen_id as YonetmenID,
gisesi as [Gisesi] from Film
-- as ile yaplan ilem alias tanmlama'dr. stunlara alias tanmlayabildiimiz gibi alias'lar 
-- tablolara da tanmlayabiliriz.
select adi + ' ' + soyadi as oyuncuadisoyadi, dogumtarihi from Oyuncu
-- metinsel ifadeler tek trnakla ifade edilir. burda adi ile soyadi stunlarn arada boluk ile 
-- birletiriyoruz, oyuncuadisoyadi isimli bir stuna alias vererek dogumtarihi ile birlikte ekiyoruz.
-- Not: SQL Server Profiler ile SQL Server'da yaptmz btn ilemleri grebiliyoruz!
select adi + ' ' + soyadi as oyuncuadisoyadi, CONVERT(varchar(10), dogumtarihi, 104) as oyuncudogumtarihi
from Oyuncu
-- CONVERT(neye evirecei, neyi evirecei, format)
-- 104: tarih format (Alman tarih format)
select CAST(id as varchar(5)) + ' - ' + adi + ' ' + soyadi as oyuncu from Oyuncu 
-- CAST(neyi evirecei as neye evirecei)
select * from Oyuncu order by adi
-- order by: stun adna gre sralama, default'u ascending (asc)
select * from Oyuncu order by adi desc
-- descending (desc)
select * from Oyuncu order by adi, soyadi
-- nce adi stununa gre artan sralama yapar, sonra adi stununa gre sraladklarn soyadi stununa gre artan sralar.
select * from Yonetmen order by adi, soyadi desc
-- nce adi stununa gre artan sralama yapar, sonra adi stununa gre sraladklarn soyadi stununa gre azalan sralar.
select * from Oyuncu order by 2
-- 2: stun ad (adi)
select * from Oyuncu order by 3 desc
-- 3: stun ad (soyadi)
select COUNT(*) from Oyuncu
select COUNT(adi) as toplamfilm from Film
-- COUNT(stun ad) veya COUNT(*): row saysn verir
select COUNT(dogumtarihi) from Oyuncu
-- COUNT(stun ad): NULL olanlar saymaz
select MAX(gisesi) as [En Cok Gise] from Film
-- MAX(stun ad): o stundaki verilerden en byk deeri ver
select MIN(gisesi) as [En Az Gise] from Film
-- MIN(stun ad): o stundaki verilerden en kk deeri ver
select SUM(gisesi) as [Toplam Gise] from Film
-- SUM(stun ad): o stundaki verilerin toplamn ver
select AVG(gisesi) as [Ortalama Gise] from Film
-- AVG(stun ad): o stundaki verilerin ortalama deerini ver
select top 5 * from Oyuncu
-- TOP say stun ad: ilk be kayd getirir
select top 5 * from Oyuncu order by 1 desc
-- Burda order by desc'den dolay son 5 kayd getirir
-- Eer tablo veya stun adlarnda boluk varsa [] kullanlmas gerek!
select top 1 * from film order by id 
-- film tablosundaki ilk kayd getirir
select top 1 * from film order by id desc 
-- film tablosundaki son kayd getirir
use master
select * from Filmler.dbo.Film
-- dbo: schema
use Filmler
select * from Oyuncu where id = 5
select * from Oyuncu where id = '5'
-- id'si 5 olan kaytlar getir. ikisi de alr, kendi kendine convert yapar (where clause'unun iinde)
select * from Oyuncu where id != 5
select * from Oyuncu where id <> 5
select * from Oyuncu where not id = 5
-- id'si 5 olmayan kaytlar getir
select * from Oyuncu where id < 4 order by id desc 
select * from Oyuncu where id > 4 -- id'ye gre artan sralama iin order by id yazmaya gerek yoktur nk id primary key ve index olduundan otomatikman id'ye gre artan sral gelir
-- where: art belirtir
/* Yorum satr 1 
 * Yorum satr 2
 * Yorum satr 3
 * Yorum satr 4
 */
select * from Oyuncu where id >= 2 and id <= 4
select * from Oyuncu where id < 2 or id > 4 -- 1. sorgu
select * from Oyuncu where not (id >= 2 and id <= 4) -- 2. sorgu
-- stteki iki sorgu ayn sonucu verir nk 1. sorgu 2. sorgunun deil operatr parantez ierisindeki koullara datlm halidir
/*
Koul 1 		and			Koul 2				Sonu Koulu		rnek Tabloda Aranan Veriler	rnek Tablodan Dnen Sonu Verileri
id >= 3						id <= 5
1 (true)					1 (true)			1 (true)			3, 4, 5							3, 4, 5
1 (true)					0 (false)			0 (false)			11								Veri dnmez
0 (false)					1 (true)			0 (false)			2								Veri dnmez
id > 5						id < 3
0 (false)					0 (false)			0 (false)			4								Veri dnmez
*/
/*
Koul 1 		or			Koul 2				Sonu Koulu		rnek Tabloda Aranan Veriler	rnek Tablodan Dnen Sonu Verileri
id >= 3						id <= 5
1 (true)					1 (true)			1 (true)			3, 4, 5							3, 4, 5
1 (true)					0 (false)			1 (true)			11, Dier veriler				11, Dier veriler
0 (false)					1 (true)			1 (true)			2, Dier veriler				2, Dier veriler
id > 5						id < 3
0 (false)					0 (false)			0 (false)			4								Veri dnmez
*/
select * from Oyuncu where id < 2 and id > 4
-- veri dnmez
select * from Oyuncu where adi = 'Sigourney' and soyadi = 'Weaver' and dogumtarihi = '1949-10-08'
select * from Oyuncu where (adi = 'Sigourney' and soyadi = 'Weaver') or adi = 'Zoe'
-- ad Sigourney ve soyad Weaver olan veya ad Zoe olan kaytlar getir
select * from Oyuncu where (adi = 'Sigourney' and soyadi = 'Weaver') or (adi = 'Zoe' and soyadi = 'Saldana')
-- ad Sigourney ve soyad Weaver olan veya ad Zoe ve soyad Saldana olan kaytlar getir
select * from Oyuncu where ((adi = 'Sigourney' and soyadi = 'Weaver') or (adi = 'Zoe' and soyadi = 'Saldana')) and dogumtarihi > '1970-01-01'
-- ad Sigourney ve soyad Weaver olan veya ad Zoe ve soyad Saldana olan ve doum tarihi 01.01.1970'ten byk olan kaytlar getir
-- eer koullarda hem and hem de or kullanlyorsa ilgili koullar mutlaka paranteze alnmaldr
select * from Tur where id = 1 or id = 3 or id = 5
select * from Tur where id in (1, 3, 5)
-- in (deerler): kme ierisinden seim yapar, deerleri parantez iindeki parametreler olanlar getir
select * from Tur where id not in (1, 3, 5)
--not in (deerler): kme dndan seim yapar, deerleri parantez dndaki parametreler olanlar getir
select * from Tur where id between 2 and 4
select * from Film where yapimyili is NULL
select * from Film where yapimyili is not null
select * from Film where adi = 'Avatar'
select * from Film where adi like 'Avatar'
-- stteki iki sorgu ayn sonucu verir nk like ierisinde % kullanlmazsa = gibi davranr
select * from Film where adi like 'a%'
-- a ile balayan sonu ne olursa olsun getir
select * from Film where adi like '%ata%'
-- iinde ata geenleri getir, ba ve sonu nemli deil
select * from Film where adi like '%de'
-- sonu de ile bitenleri getir
select * from Film where adi like 'yar%'
-- yar ile balayanlar getir 
select * from Film where adi not like 'yar%'
-- yar ile balamayanlar getir
select * from Film where adi like '%tk'
-- tk ile bitenleri getir
select * from Film where adi like '%at%'
-- iinde at geenleri getir
select * from Film where adi like '%av%'
-- iinde av geenleri getir, banda veya sonunda gese de veri dner
select * from Film where adi like '___r%'
-- ilk 3 karakteri ne olursa olsun 4. karakteri r olan ve sonras ne olursa olsun getir 
-- (sonunda hibir ey de olmayabilir, bireyler de)
select * from Oyuncu where adi like '[jr]%' order by adi
-- r veya j ile balayan kaytlar getir
select * from Oyuncu where adi like '[j-r]%' order by adi
-- ba harfi j ve r arasndaki karakterlerle balayanlar getir
select * from Oyuncu where adi like '[r-j]%' order by adi
-- [] iindeki karakterler sral olmal yoksa bo tablo dner
select * from Oyuncu where adi like '[rj]_[^c]%e'
-- r ya da j harfinden biri ile balayacak, ikinci harf nemli deil, nc c olmayacak 
-- ve arada ne geerse gesin son harfi e olacak
-- burda karakterleri 1'den saymaya balyoruz
select 'al' + ' ' + 'Alsa' AdSoyad
select 1 + 2 + 3 as Toplam
-- select her zaman bir tablo ile kullanlmaz, istenilen veriler yazlp ihtiyaca gre zerinde ilemler yaplarak ekilebilir
select adi, soyadi, 'Oyuncu' [Tablo Ad] from oyuncu
-- select ile adi ve soyadi ile birlikte 'Oyuncu' metinsel verisini de tablo ad olarak getir